<?php
$title="Durum";
$nav="status";
require_once __DIR__ . '/_top.php';
?>
<div class="d-flex align-items-center justify-content-between mb-2">
  <div>
    <div class="h5 fw-bold mb-0">🧩 Sistem Durumu</div>
    <div class="soft small">API / DB / Collector / Sayaçlar</div>
  </div>
  <div class="text-end">
    <div class="soft small">Son kontrol</div>
    <div id="lastTS" class="fw-semibold mono">-</div>
  </div>
</div>

<div class="row g-3">
  <div class="col-12 col-lg-4">
    <div class="cardx p-3">
      <div class="fw-bold mb-2">Sunucu</div>
      <div class="d-flex justify-content-between"><div>MySQL</div><div id="dbOk" class="badge-pill bg-secondary text-white">-</div></div>
      <div class="mt-2 soft small">Zaman: <span id="srvTime" class="mono">-</span></div>
    </div>
  </div>

  <div class="col-12 col-lg-8">
    <div class="cardx p-3">
      <div class="fw-bold mb-2">Windows Toplayıcı (Collector)</div>
      <div class="row g-2 small">
        <div class="col-12 col-md-4">Durum: <span id="colOk" class="badge-pill bg-secondary text-white">-</span></div>
        <div class="col-12 col-md-4">Son: <span id="colSeen" class="mono">-</span></div>
        <div class="col-12 col-md-4">Yaş: <span id="colAge" class="mono">-</span> sn</div>
        <div class="col-12 col-md-6">ID: <span id="colId" class="mono">-</span></div>
        <div class="col-12 col-md-6">Host: <span id="colHost" class="mono">-</span> • Ver: <span id="colVer" class="mono">-</span></div>
        <div class="col-12">Hata: <span id="colErr" class="mono text-danger">-</span></div>
      </div>
    </div>
  </div>

  <div class="col-12">
    <div class="cardx p-3">
      <div class="d-flex align-items-center justify-content-between mb-2">
        <div class="fw-bold">Sayaç Özet</div>
        <div class="soft small">Online = son veri ≤ 3 sn</div>
      </div>
      <div class="table-responsive">
        <table class="table table-sm align-middle mb-0">
          <thead>
            <tr>
              <th>#</th><th>Ad</th><th>IP</th><th>Unit</th><th>Durum</th><th>Son Veri</th><th>Yaş</th><th>RTT</th><th>Hata</th>
            </tr>
          </thead>
          <tbody id="rows"></tbody>
        </table>
      </div>
    </div>
  </div>
</div>

<script>
const STATUS_URL = "../api/status.php";
function pill(el, ok, tOk, tBad){
  el.className = "badge-pill " + (ok ? "bg-success text-white" : "bg-danger text-white");
  el.textContent = ok ? tOk : tBad;
}
function esc(s){return String(s??"").replace(/[&<>"']/g, m=>({ '&':'&amp;','<':'&lt;','>':'&gt;','"':'&quot;',"'":'&#39;'}[m]));}

async function tick(){
  try{
    const res = await fetch(STATUS_URL,{cache:"no-store"});
    const j = await res.json();

    pill(document.getElementById("dbOk"), !!j.db, "BAĞLI", "KOPUK");
    document.getElementById("srvTime").textContent = j.time || "-";

    const col = j.collector || {};
    pill(document.getElementById("colOk"), !!col.online, "ONLINE", "OFFLINE");
    document.getElementById("colSeen").textContent = col.last_seen || "-";
    document.getElementById("colAge").textContent = col.age_sec ?? "-";
    document.getElementById("colId").textContent = col.collector_id || "-";
    document.getElementById("colHost").textContent = col.host_name || "-";
    document.getElementById("colVer").textContent = col.version || "-";
    document.getElementById("colErr").textContent = col.last_error || "-";

    const tbody = document.getElementById("rows");
    tbody.innerHTML = "";
    (j.meters||[]).forEach(m=>{
      const online = !!m.online;
      const tr = document.createElement("tr");
      tr.innerHTML = `
        <td class="mono">${esc(m.id)}</td>
        <td>${esc(m.name)}</td>
        <td class="mono">${esc(m.ip)}:${esc(m.port)}</td>
        <td class="mono">${esc(m.unit_id ?? "-")}</td>
        <td>${online?'<span class="badge bg-success">ONLINE</span>':'<span class="badge bg-danger">OFFLINE</span>'}</td>
        <td class="mono">${esc(m.last_ts ?? "-")}</td>
        <td class="mono">${esc(m.age_sec ?? "-")} sn</td>
        <td class="mono">${esc(m.rtt_ms ?? "-")} ms</td>
        <td class="text-danger small">${esc(m.last_error ?? "")}</td>
      `;
      tbody.appendChild(tr);
    });

    document.getElementById("lastTS").textContent = new Date().toLocaleString();
  }catch(e){
    document.getElementById("lastTS").textContent = "Kontrol başarısız";
  }
}
tick();
setInterval(tick, 1000);
</script>
<?php require_once __DIR__ . '/_bottom.php'; ?>
