<?php
// panel/setup.php — İlk kurulum (admin oluşturur)
// Kurulum bitince setup.lock oluşur. Güvenlik için setup.php'yi silmen önerilir.
require_once __DIR__ . '/_db.php';

$lock = __DIR__ . '/setup.lock';
if (file_exists($lock)){
  echo "Setup kilitli. (setup.lock var) Güvenlik için setup.php silinebilir.";
  exit;
}

$err=''; $ok='';
if($_SERVER['REQUEST_METHOD']==='POST'){
  $u = trim($_POST['u'] ?? '');
  $p = (string)($_POST['p'] ?? '');
  $p2 = (string)($_POST['p2'] ?? '');
  if($u==='' || $p===''){ $err="Kullanıcı ve şifre zorunlu."; }
  elseif($p !== $p2){ $err="Şifreler aynı değil."; }
  else{
    $exists = $pdo->query("SELECT COUNT(*) c FROM panel_users")->fetch()['c'] ?? 0;
    if((int)$exists > 0){
      $err="Zaten panel_users içinde kullanıcı var. Setup iptal.";
    } else {
      $hash = password_hash($p, PASSWORD_DEFAULT);
      $st = $pdo->prepare("INSERT INTO panel_users (username, pass_hash, full_name, role, is_active) VALUES (?,?,?,?,1)");
      $st->execute([$u, $hash, 'Admin', 'admin']);
      file_put_contents($lock, "locked ".date('c'));
      $ok="Admin oluşturuldu. Artık login.php ile giriş yapabilirsin. (setup.php'yi silmen önerilir)";
    }
  }
}
?><!doctype html>
<html lang="tr"><head>
<meta charset="utf-8"><meta name="viewport" content="width=device-width, initial-scale=1">
<title>ES3 Panel Setup</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
</head><body class="bg-light">
<div class="container py-5" style="max-width:540px">
  <div class="card shadow-sm border-0 rounded-4">
    <div class="card-body p-4">
      <div class="h4 fw-bold mb-1">⚙️ ES3 Panel Setup</div>
      <div class="text-muted mb-3">İlk admin kullanıcıyı oluştur.</div>
      <?php if($err): ?><div class="alert alert-danger"><?php echo htmlspecialchars($err,ENT_QUOTES,'UTF-8'); ?></div><?php endif; ?>
      <?php if($ok): ?><div class="alert alert-success"><?php echo htmlspecialchars($ok,ENT_QUOTES,'UTF-8'); ?></div><?php endif; ?>
      <form method="post" autocomplete="off">
        <div class="mb-2">
          <label class="form-label">Admin Kullanıcı</label>
          <input class="form-control" name="u" required>
        </div>
        <div class="mb-2">
          <label class="form-label">Şifre</label>
          <input type="password" class="form-control" name="p" required>
        </div>
        <div class="mb-3">
          <label class="form-label">Şifre (tekrar)</label>
          <input type="password" class="form-control" name="p2" required>
        </div>
        <button class="btn btn-dark w-100">Admin Oluştur</button>
      </form>
      <div class="small text-muted mt-3">Kurulum bitince <b>setup.lock</b> oluşur.</div>
    </div>
  </div>
</div>
</body></html>
