<?php
$title="Raporlar";
$nav="reports";
require_once __DIR__ . '/_top.php';
require_once __DIR__ . '/_db.php';

function h($s){ return htmlspecialchars((string)$s, ENT_QUOTES, 'UTF-8'); }

$tab = trim((string)($_GET['tab'] ?? 'charts'));

$meters = $pdo->query("SELECT id, name, ip, port FROM meters WHERE is_active=1 ORDER BY id ASC")->fetchAll(PDO::FETCH_ASSOC);
$meter_id = isset($_GET['meter_id']) ? (int)$_GET['meter_id'] : 0;

$start = trim((string)($_GET['start'] ?? date('Y-m-d')));
$end   = trim((string)($_GET['end'] ?? date('Y-m-d')));

?>
<div class="d-flex align-items-center justify-content-between mb-2">
  <div>
    <div class="h5 fw-bold mb-0">📊 Raporlar & Grafikler</div>
    <div class="soft small">Enerji (kWh), Güç (kW) trend, peak ve alarmlar</div>
  </div>
</div>

<div class="cardx p-3 mb-3">
  <form class="row g-2 align-items-end" method="get">
    <input type="hidden" name="tab" value="<?php echo h($tab); ?>">
    <div class="col-12 col-md-4">
      <label class="form-label small soft">Sayaç</label>
      <select class="form-select" name="meter_id">
        <option value="0">Tümü</option>
        <?php foreach($meters as $m): ?>
          <option value="<?php echo (int)$m['id']; ?>" <?php echo ((int)$m['id']===$meter_id?'selected':''); ?>>
            #<?php echo (int)$m['id']; ?> — <?php echo h($m['name']); ?> (<?php echo h($m['ip']); ?>:<?php echo (int)$m['port']; ?>)
          </option>
        <?php endforeach; ?>
      </select>
    </div>
    <div class="col-6 col-md-3">
      <label class="form-label small soft">Başlangıç</label>
      <input type="date" class="form-control" name="start" value="<?php echo h($start); ?>">
    </div>
    <div class="col-6 col-md-3">
      <label class="form-label small soft">Bitiş</label>
      <input type="date" class="form-control" name="end" value="<?php echo h($end); ?>">
    </div>
    <div class="col-12 col-md-2 d-grid">
      <button class="btn btn-primary">Uygula</button>
    </div>
  </form>
</div>

<ul class="nav nav-pills gap-2 mb-3 flex-wrap">
  <li class="nav-item"><a class="nav-link <?php echo $tab==='charts'?'active':''; ?>" href="?tab=charts&meter_id=<?php echo (int)$meter_id; ?>&start=<?php echo h($start); ?>&end=<?php echo h($end); ?>">📈 Grafikler</a></li>
  <li class="nav-item"><a class="nav-link <?php echo $tab==='live'?'active':''; ?>" href="?tab=live&meter_id=<?php echo (int)$meter_id; ?>&start=<?php echo h($start); ?>&end=<?php echo h($end); ?>">🟢 Canlı (1 sn)</a></li>
  <li class="nav-item"><a class="nav-link <?php echo $tab==='energy'?'active':''; ?>" href="?tab=energy&meter_id=<?php echo (int)$meter_id; ?>&start=<?php echo h($start); ?>&end=<?php echo h($end); ?>">⚡ Enerji (kWh)</a></li>
  <li class="nav-item"><a class="nav-link <?php echo $tab==='monthly'?'active':''; ?>" href="?tab=monthly&meter_id=<?php echo (int)$meter_id; ?>&start=<?php echo h($start); ?>&end=<?php echo h($end); ?>">🗓️ Aylık Toplam</a></li>
  <li class="nav-item"><a class="nav-link <?php echo $tab==='compare'?'active':''; ?>" href="?tab=compare&meter_id=<?php echo (int)$meter_id; ?>&start=<?php echo h($start); ?>&end=<?php echo h($end); ?>">📦 Sayaç Karşılaştır</a></li>
  <li class="nav-item"><a class="nav-link <?php echo $tab==='alarms'?'active':''; ?>" href="?tab=alarms&meter_id=<?php echo (int)$meter_id; ?>&start=<?php echo h($start); ?>&end=<?php echo h($end); ?>">🚨 Alarmlar</a></li>
  <li class="nav-item"><a class="nav-link <?php echo $tab==='settings'?'active':''; ?>" href="?tab=settings&meter_id=<?php echo (int)$meter_id; ?>&start=<?php echo h($start); ?>&end=<?php echo h($end); ?>">⚙️ Alarm Ayarları</a></li>
</ul>

<?php if($tab==='live'): ?>
  <div class="alert alert-info small">
    Bu ekran <b>1 saniyelik</b> SSE (stream) ile çalışır. Seçili sayaçtan gelen <b>kW</b> ve <b>kWh</b> değerleri canlı grafiğe eklenir.
    <div class="soft">Not: Canlı grafikte son 180 saniye tutulur (performans için).</div>
  </div>

  <div class="cardx p-3 mb-3">
    <div class="d-flex align-items-center justify-content-between flex-wrap gap-2">
      <div class="fw-bold">🟢 Canlı Grafik (1 sn)</div>
      <div class="d-flex gap-2">
        <button type="button" class="btn btn-outline-secondary btn-sm" id="btnPause">Duraklat</button>
        <button type="button" class="btn btn-outline-primary btn-sm" id="btnResume" disabled>Devam</button>
      </div>
    </div>
    <div class="soft small mt-1" id="liveInfo">Bağlanıyor...</div>
    <canvas id="chartLiveKW" height="140" class="mt-2"></canvas>
    <canvas id="chartLiveKWH" height="120" class="mt-3"></canvas>
  </div>

<?php elseif($tab==='monthly'): ?>
  <div class="d-flex flex-wrap gap-2 mb-2">
    <a class="btn btn-success btn-sm" href="export_excel.php?type=monthly&meter_id=<?php echo (int)$meter_id; ?>&start=<?php echo h($start); ?>&end=<?php echo h($end); ?>">⬇️ Excel indir</a>
    <a class="btn btn-danger btn-sm" href="export_pdf.php?type=monthly&meter_id=<?php echo (int)$meter_id; ?>&start=<?php echo h($start); ?>&end=<?php echo h($end); ?>">⬇️ PDF indir</a>
  </div>

  <div class="cardx p-3 mb-3">
    <div class="fw-bold mb-2">Aylık Toplam Enerji (kWh)</div>
    <canvas id="chartMonthly" height="120"></canvas>
    <div class="soft small mt-2">Not: Aylık tüketim = (ay içindeki max kWh) - (min kWh)</div>
  </div>

  <div class="cardx p-3">
    <div class="fw-bold mb-2">Aylık Özet Tablosu</div>
    <div class="table-responsive">
      <table class="table table-sm table-bordered align-middle text-center mb-0">
        <thead class="table-dark"><tr><th>Ay</th><th>Toplam (kWh)</th></tr></thead>
        <tbody id="monthlyRows"><tr><td colspan="2" class="soft">Yükleniyor...</td></tr></tbody>
      </table>
    </div>
  </div>

<?php elseif($tab==='compare'): ?>
  <div class="d-flex flex-wrap gap-2 mb-2">
    <a class="btn btn-success btn-sm" href="export_excel.php?type=compare&meter_id=<?php echo (int)$meter_id; ?>&start=<?php echo h($start); ?>&end=<?php echo h($end); ?>">⬇️ Excel indir</a>
    <a class="btn btn-danger btn-sm" href="export_pdf.php?type=compare&meter_id=<?php echo (int)$meter_id; ?>&start=<?php echo h($start); ?>&end=<?php echo h($end); ?>">⬇️ PDF indir</a>
  </div>

  <div class="cardx p-3 mb-3">
    <div class="fw-bold mb-2">Sayaç Bazlı Karşılaştırma (kWh)</div>
    <canvas id="chartCompareKWH" height="120"></canvas>
  </div>

  <div class="cardx p-3 mb-3">
    <div class="fw-bold mb-2">Sayaç Bazlı Peak (kW)</div>
    <canvas id="chartCompareKW" height="120"></canvas>
  </div>

  <div class="cardx p-3">
    <div class="fw-bold mb-2">Detay Tablo</div>
    <div class="table-responsive">
      <table class="table table-sm table-bordered align-middle text-center mb-0">
        <thead class="table-dark"><tr><th>Sayaç</th><th>kWh</th><th>kW Peak</th><th>PF Ort.</th><th>Online %</th></tr></thead>
        <tbody id="compareRows"><tr><td colspan="5" class="soft">Yükleniyor...</td></tr></tbody>
      </table>
    </div>
  </div>

<?php elseif($tab==='energy'): ?>
  <div class="d-flex flex-wrap gap-2 mb-2">
    <a class="btn btn-success btn-sm" href="export_excel.php?type=energy&meter_id=<?php echo (int)$meter_id; ?>&start=<?php echo h($start); ?>&end=<?php echo h($end); ?>">⬇️ Excel indir</a>
    <a class="btn btn-danger btn-sm" href="export_pdf.php?type=energy&meter_id=<?php echo (int)$meter_id; ?>&start=<?php echo h($start); ?>&end=<?php echo h($end); ?>">⬇️ PDF indir</a>
  </div>

  <div class="cardx p-3 mb-3">
    <div class="fw-bold mb-2">Günlük kWh Tüketim</div>
    <canvas id="chartEnergy" height="120"></canvas>
    <div class="soft small mt-2">Not: Günlük tüketim = (gün içindeki max kWh) - (min kWh)</div>
  </div>

  <div class="cardx p-3">
    <div class="fw-bold mb-2">Günlük Özet Tablosu</div>
    <div class="table-responsive">
      <table class="table table-sm table-bordered align-middle text-center mb-0">
        <thead class="table-dark"><tr><th>Gün</th><th>Toplam (kWh)</th></tr></thead>
        <tbody id="energyRows"><tr><td colspan="2" class="soft">Yükleniyor...</td></tr></tbody>
      </table>
    </div>
  </div>

<?php elseif($tab==='alarms'): ?>
  <div class="d-flex flex-wrap gap-2 mb-2">
    <a class="btn btn-success btn-sm" href="export_excel.php?type=power&meter_id=<?php echo (int)$meter_id; ?>&start=<?php echo h($start); ?>&end=<?php echo h($end); ?>">⬇️ Excel indir (kW)</a>
    <a class="btn btn-danger btn-sm" href="export_pdf.php?type=power&meter_id=<?php echo (int)$meter_id; ?>&start=<?php echo h($start); ?>&end=<?php echo h($end); ?>">⬇️ PDF indir (kW)</a>
  </div>

  <div class="cardx p-3 mb-3">
    <div class="fw-bold mb-2">Son Alarmlar (WARN/ERROR)</div>
    <div class="table-responsive">
      <table class="table table-sm table-bordered align-middle mb-0">
        <thead class="table-dark"><tr><th>Zaman</th><th>Seviye</th><th>Kaynak</th><th>Sayaç</th><th>Mesaj</th></tr></thead>
        <tbody id="alarmRows"><tr><td colspan="5" class="soft">Yükleniyor...</td></tr></tbody>
      </table>
    </div>
  </div>

  <div class="cardx p-3">
    <div class="fw-bold mb-2">Peak / Minimumlar (Seçili Aralık)</div>
    <div class="table-responsive">
      <table class="table table-sm table-bordered align-middle text-center mb-0">
        <thead class="table-dark"><tr><th>Sayaç</th><th>kW Peak</th><th>PF Min</th><th>V Min</th><th>V Max</th></tr></thead>
        <tbody id="peaksRows"><tr><td colspan="5" class="soft">Yükleniyor...</td></tr></tbody>
      </table>
    </div>
  </div>

<?php elseif($tab==='settings'): ?>
  <?php
    $thrRows = $pdo->query("
      SELECT m.id, m.name, m.ip, m.port,
             t.offline_after_sec, t.kw_peak_limit, t.pf_min, t.v_min, t.v_max, t.email_to, t.email_enabled
      FROM meters m
      LEFT JOIN meter_thresholds t ON t.meter_id=m.id
      WHERE m.is_active=1
      ORDER BY m.id ASC
    ")->fetchAll(PDO::FETCH_ASSOC);
  ?>
  <div class="alert alert-info small">
    <div class="fw-semibold">Alarm mantığı</div>
    kW limit, PF min ve voltaj min/max değerlerini girersen sistem <b>ALARM</b> event'i üretir. E-posta açık ise hosting mail() ile gönderir.
  </div>

  <?php if(isset($_GET['ok'])): ?><div class="alert alert-success">Kaydedildi ✅</div><?php endif; ?>

  <?php foreach($thrRows as $r): ?>
    <div class="cardx p-3 mb-3">
      <div class="d-flex align-items-center justify-content-between flex-wrap gap-2">
        <div class="fw-bold">#<?php echo (int)$r['id']; ?> — <?php echo h($r['name']); ?> <span class="soft small">(<?php echo h($r['ip']); ?>:<?php echo (int)$r['port']; ?>)</span></div>
      </div>

      <form class="row g-2 mt-1" method="post" action="alarms_save.php">
        <input type="hidden" name="meter_id" value="<?php echo (int)$r['id']; ?>">
        <div class="col-6 col-md-2">
          <label class="form-label small soft">Offline (sn)</label>
          <input class="form-control" type="number" min="1" name="offline_after_sec" value="<?php echo h($r['offline_after_sec'] ?? 5); ?>">
        </div>
        <div class="col-6 col-md-2">
          <label class="form-label small soft">kW limit</label>
          <input class="form-control" name="kw_peak_limit" value="<?php echo h($r['kw_peak_limit']); ?>" placeholder="örn 120">
        </div>
        <div class="col-6 col-md-2">
          <label class="form-label small soft">PF min</label>
          <input class="form-control" name="pf_min" value="<?php echo h($r['pf_min']); ?>" placeholder="örn 0.90">
        </div>
        <div class="col-6 col-md-2">
          <label class="form-label small soft">V min</label>
          <input class="form-control" name="v_min" value="<?php echo h($r['v_min']); ?>" placeholder="örn 200">
        </div>
        <div class="col-6 col-md-2">
          <label class="form-label small soft">V max</label>
          <input class="form-control" name="v_max" value="<?php echo h($r['v_max']); ?>" placeholder="örn 250">
        </div>
        <div class="col-12 col-md-4">
          <label class="form-label small soft">E-posta</label>
          <input class="form-control" name="email_to" value="<?php echo h($r['email_to']); ?>" placeholder="mail@domain.com">
        </div>
        <div class="col-12 col-md-3 d-flex align-items-center gap-2">
          <div class="form-check mt-4">
            <input class="form-check-input" type="checkbox" id="em<?php echo (int)$r['id']; ?>" name="email_enabled" <?php echo ((int)$r['email_enabled']===1?'checked':''); ?>>
            <label class="form-check-label" for="em<?php echo (int)$r['id']; ?>">E-posta aktif</label>
          </div>
        </div>
        <div class="col-12 col-md-2 d-grid mt-3">
          <button class="btn btn-primary">Kaydet</button>
        </div>
      </form>
    </div>
  <?php endforeach; ?>

<?php else: ?>
  <div class="d-flex flex-wrap gap-2 mb-2">
    <a class="btn btn-success btn-sm" href="export_excel.php?type=power&meter_id=<?php echo (int)$meter_id; ?>&start=<?php echo h($start); ?>&end=<?php echo h($end); ?>">⬇️ Excel indir (kW)</a>
    <a class="btn btn-danger btn-sm" href="export_pdf.php?type=power&meter_id=<?php echo (int)$meter_id; ?>&start=<?php echo h($start); ?>&end=<?php echo h($end); ?>">⬇️ PDF indir (kW)</a>
  </div>

  <div class="cardx p-3 mb-3">
    <div class="fw-bold mb-2">kW Trend (Seçili Aralık)</div>
    <canvas id="chartKW" height="120"></canvas>
  </div>

  <div class="cardx p-3">
    <div class="fw-bold mb-2">PF Trend (Seçili Aralık)</div>
    <canvas id="chartPF" height="120"></canvas>
  </div>
<?php endif; ?>

<script src="https://cdn.jsdelivr.net/npm/chart.js@4.4.1/dist/chart.umd.min.js"></script>
<script>
const meterId = <?php echo (int)$meter_id; ?>;
const start = <?php echo json_encode($start); ?>;
const end   = <?php echo json_encode($end); ?>;
const tab   = <?php echo json_encode($tab); ?>;

function fmt(n){
  if (n===null || n===undefined) return '-';
  const x = Number(n);
  if (Number.isNaN(x)) return '-';
  return x.toFixed(2);
}

async function loadEnergy(){
  const res = await fetch(`report_api.php?mode=energy&meter_id=${meterId}&start=${encodeURIComponent(start)}&end=${encodeURIComponent(end)}`);
  const j = await res.json();
  if(!j.ok) return;

  const labels = j.items.map(x=>x.day);
  const totals = j.items.map(x=>x.total || 0);

  const tbody = document.getElementById('energyRows');
  tbody.innerHTML = j.items.map(x=>`<tr><td>${x.day}</td><td class="fw-semibold">${fmt(x.total)}</td></tr>`).join('') || `<tr><td colspan="2" class="soft">Kayıt yok</td></tr>`;

  new Chart(document.getElementById('chartEnergy'), {
    type: 'line',
    data: { labels, datasets: [{ label: 'Toplam kWh', data: totals, tension: .25 }]},
    options: { responsive:true, maintainAspectRatio:false, plugins:{legend:{display:true}} }
  });
}

async function loadMonthly(){
  const res = await fetch(`report_api.php?mode=monthly&meter_id=${meterId}&start=${encodeURIComponent(start)}&end=${encodeURIComponent(end)}`);
  const j = await res.json();
  if(!j.ok) return;

  const labels = j.items.map(x=>x.month);
  const totals = j.items.map(x=>x.total || 0);

  const tbody = document.getElementById('monthlyRows');
  tbody.innerHTML = j.items.map(x=>`<tr><td>${x.month}</td><td class="fw-semibold">${fmt(x.total)}</td></tr>`).join('') || `<tr><td colspan="2" class="soft">Kayıt yok</td></tr>`;

  new Chart(document.getElementById('chartMonthly'), {
    type: 'bar',
    data: { labels, datasets: [{ label: 'Toplam kWh', data: totals }]},
    options: { responsive:true, maintainAspectRatio:false, plugins:{legend:{display:true}} }
  });
}

async function loadCompare(){
  const res = await fetch(`report_api.php?mode=compare&meter_id=${meterId}&start=${encodeURIComponent(start)}&end=${encodeURIComponent(end)}`);
  const j = await res.json();
  if(!j.ok) return;

  const items = j.items || [];
  const labels = items.map(x=>`#${x.meter_id} ${x.name}`);
  const kwh = items.map(x=>Number(x.kwh_total ?? 0));
  const kwp = items.map(x=>Number(x.kw_peak ?? 0));

  const tbody = document.getElementById('compareRows');
  tbody.innerHTML = items.map(x=>`
    <tr>
      <td class="text-start fw-semibold">#${x.meter_id} — ${x.name}</td>
      <td>${fmt(x.kwh_total)}</td>
      <td>${fmt(x.kw_peak)}</td>
      <td>${fmt(x.pf_avg)}</td>
      <td>${fmt(x.online_pct)}%</td>
    </tr>`).join('') || `<tr><td colspan="5" class="soft">Kayıt yok</td></tr>`;

  new Chart(document.getElementById('chartCompareKWH'), {
    type: 'bar',
    data: { labels, datasets: [{ label: 'kWh', data: kwh }]},
    options: { responsive:true, maintainAspectRatio:false, plugins:{legend:{display:true}}, scales:{x:{display:false}} }
  });

  new Chart(document.getElementById('chartCompareKW'), {
    type: 'bar',
    data: { labels, datasets: [{ label: 'kW Peak', data: kwp }]},
    options: { responsive:true, maintainAspectRatio:false, plugins:{legend:{display:true}}, scales:{x:{display:false}} }
  });
}

function initLive(){
  const info = document.getElementById('liveInfo');
  const btnPause = document.getElementById('btnPause');
  const btnResume = document.getElementById('btnResume');

  // live requires a meter id
  let mid = meterId;
  if (!mid || mid<=0){
    const sel = document.querySelector('select[name="meter_id"]');
    if (sel && sel.options && sel.options.length>1) mid = Number(sel.options[1].value||0);
  }
  if (!mid || mid<=0){
    info.innerText = 'Canlı grafik için sayaç seçin.';
    return;
  }

  const maxPoints = 180;
  const labels = [];
  const dataKW = [];
  const dataKWH = [];
  let paused = false;
  let es = null;

  const chartKW = new Chart(document.getElementById('chartLiveKW'), {
    type: 'line',
    data: { labels, datasets: [{ label: 'kW', data: dataKW, tension: .25 }]},
    options: { responsive:true, maintainAspectRatio:false, plugins:{legend:{display:true}}, scales:{x:{display:false}} }
  });
  const chartKWH = new Chart(document.getElementById('chartLiveKWH'), {
    type: 'line',
    data: { labels, datasets: [{ label: 'kWh (Toplam)', data: dataKWH, tension: .25 }]},
    options: { responsive:true, maintainAspectRatio:false, plugins:{legend:{display:true}}, scales:{x:{display:false}} }
  });

  function pushPoint(ts, kw, kwh){
    if (paused) return;
    labels.push(ts);
    dataKW.push(kw);
    dataKWH.push(kwh);
    while(labels.length > maxPoints){ labels.shift(); dataKW.shift(); dataKWH.shift(); }
    chartKW.update('none');
    chartKWH.update('none');
  }

  function connect(){
    if (es) try{ es.close(); }catch(e){}
    info.innerText = `Bağlanıyor... (Sayaç #${mid})`;
    es = new EventSource(`live_sse.php?meter_id=${encodeURIComponent(mid)}`);
    es.addEventListener('tick', (ev)=>{
      try{
        const j = JSON.parse(ev.data);
        if(!j.ok) return;
        info.innerText = `Sayaç #${j.meter_id} • ${j.name} • ${j.online? 'ONLINE':'OFFLINE'} • TS: ${j.ts} • RTT: ${j.rtt_ms ?? '-'} ms`;
        pushPoint(j.ts, j.p_total_kw ?? null, j.kwh_import_total ?? null);
      }catch(e){}
    });
    es.addEventListener('error', ()=>{
      info.innerText = 'Bağlantı koptu, yeniden deneniyor...';
    });
  }

  btnPause?.addEventListener('click', ()=>{
    paused = true;
    btnPause.disabled = true;
    btnResume.disabled = false;
  });
  btnResume?.addEventListener('click', ()=>{
    paused = false;
    btnPause.disabled = false;
    btnResume.disabled = true;
  });

  connect();
}

async function loadPowerCharts(){
  const res = await fetch(`report_api.php?mode=power&meter_id=${meterId}&start=${encodeURIComponent(start)}&end=${encodeURIComponent(end)}`);
  const j = await res.json();
  if(!j.ok) return;

  const labels = j.items.map(x=>x.ts);
  const kw = j.items.map(x=>x.p_total_kw ?? null);
  const pf = j.items.map(x=>x.pf ?? null);

  new Chart(document.getElementById('chartKW'), {
    type: 'line',
    data: { labels, datasets: [{ label: 'kW', data: kw, tension: .25 }]},
    options: { responsive:true, maintainAspectRatio:false, plugins:{legend:{display:true}}, scales:{x:{display:false}} }
  });

  new Chart(document.getElementById('chartPF'), {
    type: 'line',
    data: { labels, datasets: [{ label: 'PF', data: pf, tension: .25 }]},
    options: { responsive:true, maintainAspectRatio:false, plugins:{legend:{display:true}}, scales:{x:{display:false}, y:{suggestedMin:0, suggestedMax:1}} }
  });
}

async function loadAlarms(){
  const res = await fetch(`report_api.php?mode=alarms&meter_id=${meterId}&start=${encodeURIComponent(start)}&end=${encodeURIComponent(end)}`);
  const j = await res.json();
  const tbody = document.getElementById('alarmRows');
  if(!j.ok){ tbody.innerHTML = `<tr><td colspan="5" class="soft">Hata</td></tr>`; return; }
  tbody.innerHTML = (j.items||[]).map(x=>`
    <tr>
      <td class="mono">${x.ts}</td>
      <td><span class="badge ${x.level==='ERROR'?'bg-danger':'bg-warning text-dark'}">${x.level}</span></td>
      <td>${x.source}</td>
      <td class="text-center">${x.meter_id ?? '-'}</td>
      <td>${x.message}</td>
    </tr>`).join('') || `<tr><td colspan="5" class="soft">Kayıt yok</td></tr>`;

  const res2 = await fetch(`report_api.php?mode=peaks&meter_id=${meterId}&start=${encodeURIComponent(start)}&end=${encodeURIComponent(end)}`);
  const j2 = await res2.json();
  const tbody2 = document.getElementById('peaksRows');
  if(!j2.ok){ tbody2.innerHTML = `<tr><td colspan="5" class="soft">Hata</td></tr>`; return; }
  tbody2.innerHTML = (j2.items||[]).map(x=>`
    <tr>
      <td class="fw-semibold">#${x.meter_id}</td>
      <td>${fmt(x.kw_peak)}</td>
      <td>${fmt(x.pf_min)}</td>
      <td>${fmt(x.v_min)}</td>
      <td>${fmt(x.v_max)}</td>
    </tr>`).join('') || `<tr><td colspan="5" class="soft">Kayıt yok</td></tr>`;
}

(async ()=>{
  if (tab==='live') initLive();
  else if (tab==='monthly') await loadMonthly();
  else if (tab==='compare') await loadCompare();
  else if (tab==='energy') await loadEnergy();
  else if (tab==='alarms') await loadAlarms();
  else if (tab==='charts') await loadPowerCharts();
})();
</script>

<?php require_once __DIR__ . '/_bottom.php'; ?>
