<?php
$title="Sayaçlar";
$nav="meters";
require_once __DIR__ . '/_top.php';
require_once __DIR__ . '/_db.php';

$err=''; $ok='';
if($_SERVER['REQUEST_METHOD']==='POST'){
  $action = $_POST['action'] ?? '';
  if ($action==='save'){
    $id = (int)($_POST['id'] ?? 0);
    $name = trim($_POST['name'] ?? '');
    $ip = trim($_POST['ip'] ?? '');
    $port = (int)($_POST['port'] ?? 502);
    $unit_id_raw = trim($_POST['unit_id'] ?? '');
    $unit_id = ($unit_id_raw==='' ? null : (int)$unit_id_raw);
    $is_active = (int)!!($_POST['is_active'] ?? 0);
    $note = trim($_POST['note'] ?? '');

    if($name==='' || $ip===''){ $err="Ad ve IP zorunlu."; }
    else{
      if($id>0){
        $st=$pdo->prepare("UPDATE meters SET name=?, ip=?, port=?, unit_id=?, is_active=?, note=? WHERE id=?");
        $st->execute([$name,$ip,$port,$unit_id,$is_active,$note,$id]);
      }else{
        $st=$pdo->prepare("INSERT INTO meters (name, ip, port, unit_id, is_active, note) VALUES (?,?,?,?,?,?)");
        $st->execute([$name,$ip,$port,$unit_id,$is_active,$note]);
      }
      $ok="Kaydedildi.";
    }
  } elseif ($action==='delete'){
    $id=(int)($_POST['id'] ?? 0);
    if($id>0){
      $pdo->prepare("DELETE FROM meters WHERE id=?")->execute([$id]);
      $ok="Silindi.";
    }
  }
}

$items = $pdo->query("SELECT * FROM meters ORDER BY id ASC")->fetchAll();
?>
<div class="d-flex align-items-center justify-content-between mb-2">
  <div>
    <div class="h5 fw-bold mb-0">🧾 Sayaç Yönetimi</div>
    <div class="soft small">IP / Port / Unit / Aktif-Pasif</div>
  </div>
  <button class="btn btn-dark btn-sm" data-bs-toggle="modal" data-bs-target="#mForm" onclick="openForm()">+ Yeni</button>
</div>

<?php if($err): ?><div class="alert alert-danger"><?php echo htmlspecialchars($err,ENT_QUOTES,'UTF-8'); ?></div><?php endif; ?>
<?php if($ok): ?><div class="alert alert-success"><?php echo htmlspecialchars($ok,ENT_QUOTES,'UTF-8'); ?></div><?php endif; ?>

<div class="cardx p-3">
  <div class="table-responsive">
    <table class="table table-sm align-middle mb-0">
      <thead>
        <tr>
          <th>#</th><th>Ad</th><th>IP</th><th>Port</th><th>Unit</th><th>Aktif</th><th>Not</th><th class="text-end">İşlem</th>
        </tr>
      </thead>
      <tbody>
        <?php foreach($items as $m): ?>
          <tr>
            <td class="mono"><?php echo (int)$m['id']; ?></td>
            <td><?php echo htmlspecialchars($m['name'],ENT_QUOTES,'UTF-8'); ?></td>
            <td class="mono"><?php echo htmlspecialchars($m['ip'],ENT_QUOTES,'UTF-8'); ?></td>
            <td class="mono"><?php echo (int)$m['port']; ?></td>
            <td class="mono"><?php echo ($m['unit_id']===null?' - ':(int)$m['unit_id']); ?></td>
            <td><?php echo ((int)$m['is_active']===1?'<span class="badge bg-success">Aktif</span>':'<span class="badge bg-secondary">Pasif</span>'); ?></td>
            <td class="small"><?php echo htmlspecialchars((string)($m['note'] ?? ''),ENT_QUOTES,'UTF-8'); ?></td>
            <td class="text-end">
              <button class="btn btn-outline-dark btn-sm" data-bs-toggle="modal" data-bs-target="#mForm"
                onclick='openForm(<?php echo json_encode($m, JSON_UNESCAPED_UNICODE); ?>)'>Düzenle</button>
              <form method="post" class="d-inline" onsubmit="return confirm('Silinsin mi?')">
                <input type="hidden" name="action" value="delete">
                <input type="hidden" name="id" value="<?php echo (int)$m['id']; ?>">
                <button class="btn btn-outline-danger btn-sm">Sil</button>
              </form>
            </td>
          </tr>
        <?php endforeach; ?>
      </tbody>
    </table>
  </div>
</div>

<!-- Modal -->
<div class="modal fade" id="mForm" tabindex="-1">
  <div class="modal-dialog">
    <div class="modal-content" style="border-radius:18px">
      <div class="modal-header">
        <div class="modal-title fw-bold">Sayaç</div>
        <button class="btn-close" data-bs-dismiss="modal"></button>
      </div>
      <form method="post" class="modal-body">
        <input type="hidden" name="action" value="save">
        <input type="hidden" name="id" id="id" value="0">
        <div class="mb-2">
          <label class="form-label">Ad</label>
          <input class="form-control" name="name" id="name" required>
        </div>
        <div class="row g-2">
          <div class="col-7">
            <label class="form-label">IP</label>
            <input class="form-control mono" name="ip" id="ip" required>
          </div>
          <div class="col-5">
            <label class="form-label">Port</label>
            <input class="form-control mono" name="port" id="port" value="502">
          </div>
        </div>
        <div class="row g-2 mt-0">
          <div class="col-7">
            <label class="form-label">Unit ID (boşsa otomatik)</label>
            <input class="form-control mono" name="unit_id" id="unit_id" placeholder="örn: 1">
          </div>
          <div class="col-5 d-flex align-items-end">
            <div class="form-check">
              <input class="form-check-input" type="checkbox" name="is_active" id="is_active" value="1" checked>
              <label class="form-check-label">Aktif</label>
            </div>
          </div>
        </div>
        <div class="mt-2">
          <label class="form-label">Not</label>
          <input class="form-control" name="note" id="note">
        </div>
        <div class="modal-footer px-0">
          <button class="btn btn-outline-secondary" type="button" data-bs-dismiss="modal">Kapat</button>
          <button class="btn btn-dark" type="submit">Kaydet</button>
        </div>
      </form>
    </div>
  </div>
</div>

<script>
function openForm(item=null){
  document.getElementById("id").value = item?.id ?? 0;
  document.getElementById("name").value = item?.name ?? "";
  document.getElementById("ip").value = item?.ip ?? "";
  document.getElementById("port").value = item?.port ?? 502;
  document.getElementById("unit_id").value = (item?.unit_id ?? "");
  document.getElementById("is_active").checked = Number(item?.is_active ?? 1) === 1;
  document.getElementById("note").value = item?.note ?? "";
}
</script>

<?php require_once __DIR__ . '/_bottom.php'; ?>
