<?php
$title="Logs";
$nav="logs";
require_once __DIR__ . '/_top.php';
?>
<div class="d-flex align-items-center justify-content-between mb-2">
  <div>
    <div class="h5 fw-bold mb-0">📜 Sistem Logs</div>
    <div class="soft small">Offline / hata olayları</div>
  </div>
  <div class="text-end">
    <div class="soft small">Otomatik yenileme</div>
    <div class="fw-semibold mono">1 sn</div>
  </div>
</div>

<div class="cardx p-3">
  <div class="table-responsive">
    <table class="table table-sm align-middle mb-0">
      <thead>
        <tr><th>Zaman</th><th>Seviye</th><th>Kaynak</th><th>Sayaç</th><th>Mesaj</th></tr>
      </thead>
      <tbody id="rows"></tbody>
    </table>
  </div>
</div>

<script>
const API = "../api/events.php?limit=120";
function esc(s){return String(s??"").replace(/[&<>"']/g, m=>({ '&':'&amp;','<':'&lt;','>':'&gt;','"':'&quot;',"'":'&#39;'}[m]));}
function badge(level){
  if(level==="ERROR") return '<span class="badge bg-danger">ERROR</span>';
  if(level==="WARN") return '<span class="badge bg-warning text-dark">WARN</span>';
  return '<span class="badge bg-secondary">INFO</span>';
}
async function tick(){
  try{
    const res = await fetch(API,{cache:"no-store"});
    const j = await res.json();
    const tbody = document.getElementById("rows");
    tbody.innerHTML = "";
    (j.items||[]).forEach(x=>{
      const tr = document.createElement("tr");
      tr.innerHTML = `
        <td class="mono">${esc(x.ts)}</td>
        <td>${badge(x.level)}</td>
        <td class="mono">${esc(x.source)}</td>
        <td>${esc(x.meter_name || "")} <span class="soft small mono">${esc(x.ip || "")}</span></td>
        <td class="small">${esc(x.message)}</td>
      `;
      tbody.appendChild(tr);
    });
  }catch(e){}
}
tick();
setInterval(tick, 1000);
</script>
<?php require_once __DIR__ . '/_bottom.php'; ?>
