<?php
require_once __DIR__ . '/_auth.php';
if (is_logged_in()){ header("Location: index.php"); exit; }

$err='';
if($_SERVER['REQUEST_METHOD']==='POST'){
  $u = trim($_POST['u'] ?? '');
  $p = (string)($_POST['p'] ?? '');
  if (do_login($u,$p)){
    header("Location: index.php"); exit;
  }
  $err = "Hatalı kullanıcı adı veya şifre.";
}
?><!doctype html>
<html lang="tr"><head>
<meta charset="utf-8"><meta name="viewport" content="width=device-width, initial-scale=1">
<title>ES3 Panel • Giriş</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
<link rel="stylesheet" href="assets/app.css">
</head><body class="d-flex align-items-center" style="min-height:100vh">
<div class="container" style="max-width:480px">
  <div class="cardx p-4">
    <div class="text-center mb-3">
      <div class="display-6 fw-bold">⚡</div>
      <div class="h4 fw-bold mb-0">ES3 Canlı İzleme</div>
      <div class="soft">DB kullanıcı girişli panel</div>
    </div>
    <?php if($err): ?><div class="alert alert-danger"><?php echo htmlspecialchars($err,ENT_QUOTES,'UTF-8'); ?></div><?php endif; ?>
    <form method="post" autocomplete="off">
      <div class="mb-2">
        <label class="form-label">Kullanıcı</label>
        <input class="form-control" name="u" required>
      </div>
      <div class="mb-3">
        <label class="form-label">Şifre</label>
        <input type="password" class="form-control" name="p" required>
      </div>
      <button class="btn btn-dark w-100 fw-semibold">Giriş Yap</button>
      <div class="small soft mt-3">
        İlk kurulum için: <b>/panel/setup.php</b> (admin yoksa)
      </div>
    </form>
  </div>
</div>
</body></html>
