<?php
// panel/lib/simple_pdf.php
// Tiny PDF generator (single-font, text/table) - no external dependencies.

function spdf_escape($s){
  return str_replace(['\\','(',')',"\r"], ['\\\\','\\(','\\)',''], (string)$s);
}

function spdf_build($lines, $title='ES3 Rapor'){
  $pages = [];
  $maxLinesPerPage = 45;
  $chunks = array_chunk($lines, $maxLinesPerPage);
  foreach($chunks as $chunk){
    $y = 800; // points
    $content = "BT\n/F1 10 Tf\n";
    foreach($chunk as $ln){
      $ln = spdf_escape($ln);
      $content .= sprintf("1 0 0 1 40 %d Tm (%s) Tj\n", $y, $ln);
      $y -= 16;
    }
    $content .= "ET\n";
    $pages[] = $content;
  }

  $objects = [];
  $offsets = [0];
  $pdf = "%PDF-1.4\n";
  $objNum = 1;

  // Font object
  $fontObj = $objNum++;
  $objects[$fontObj] = "<< /Type /Font /Subtype /Type1 /BaseFont /Helvetica >>";

  // Pages will be created later
  $kids = [];
  $pageObjs = [];
  $contentObjs = [];

  foreach($pages as $pageContent){
    $contentObj = $objNum++;
    $stream = $pageContent;
    $objects[$contentObj] = "<< /Length ".strlen($stream)." >>\nstream\n".$stream."endstream";
    $contentObjs[] = $contentObj;

    $pageObj = $objNum++;
    $objects[$pageObj] = "PAGE_PLACEHOLDER";
    $pageObjs[] = $pageObj;
    $kids[] = $pageObj." 0 R";
  }

  $pagesObj = $objNum++;
  $objects[$pagesObj] = "<< /Type /Pages /Kids [ ".implode(' ', $kids)." ] /Count ".count($kids)." /MediaBox [0 0 595 842] >>";

  // Replace page placeholders
  for($i=0;$i<count($pageObjs);$i++){
    $p = $pageObjs[$i];
    $c = $contentObjs[$i];
    $objects[$p] = "<< /Type /Page /Parent ".$pagesObj." 0 R /Resources << /Font << /F1 ".$fontObj." 0 R >> >> /Contents ".$c." 0 R >>";
  }

  $catalogObj = $objNum++;
  $objects[$catalogObj] = "<< /Type /Catalog /Pages ".$pagesObj." 0 R >>";

  // Write objects
  $xrefStart = 0;
  $offsets = [0];
  for($i=1;$i<$objNum;$i++){
    $offsets[$i] = strlen($pdf);
    $pdf .= $i." 0 obj\n".$objects[$i]."\nendobj\n";
  }

  $xrefStart = strlen($pdf);
  $pdf .= "xref\n0 ".$objNum."\n";
  $pdf .= "0000000000 65535 f \n";
  for($i=1;$i<$objNum;$i++){
    $pdf .= sprintf("%010d 00000 n \n", $offsets[$i]);
  }
  $pdf .= "trailer\n<< /Size ".$objNum." /Root ".$catalogObj." 0 R >>\nstartxref\n".$xrefStart."\n%%EOF";

  return $pdf;
}

function spdf_output_table($title, $headers, $rows){
  $lines = [];
  $lines[] = $title;
  $lines[] = str_repeat('-', 90);
  $lines[] = implode(' | ', $headers);
  $lines[] = str_repeat('-', 90);
  foreach($rows as $r){
    $lines[] = implode(' | ', array_map(function($v){
      $v = (string)$v;
      $v = preg_replace('/\s+/', ' ', $v);
      if (mb_strlen($v,'UTF-8') > 30) $v = mb_substr($v,0,27,'UTF-8').'...';
      return $v;
    }, $r));
  }
  return spdf_build($lines, $title);
}
