<?php
$title="Canlı";
$nav="live";
require_once __DIR__ . '/_top.php';
?>
<div class="d-flex align-items-center justify-content-between mb-2">
  <div>
    <div class="h5 fw-bold mb-0">🔴 Canlı Sayaçlar</div>
    <div class="soft small">SSE canlı akış (1 sn)</div>
  </div>
  <div class="text-end">
    <div class="soft small">Son güncelleme</div>
    <div id="lastTS" class="fw-semibold mono">-</div>
  </div>
</div>

<div id="kpis" class="row g-2 mb-2"></div>
<div id="grid" class="row g-3"></div>

<script>
const STREAM_URL = "../api/stream.php";
const LIVE_URL   = "../api/live.php";
const STATUS_URL = "../api/status.php";

function esc(s){return String(s??"").replace(/[&<>"']/g, m=>({ '&':'&amp;','<':'&lt;','>':'&gt;','"':'&quot;',"'":'&#39;'}[m]));}
function fmt(v,d=2){ if(v===null||v===undefined||v==="") return "-"; const n=Number(v); if(Number.isNaN(n)) return "-"; return n.toFixed(d);}

function renderKpis(status){
  const meters = (status.meters||[]);
  const online = meters.filter(m=>m.online).length;
  const total = meters.length;
  const col = status.collector || {};
  const db = !!status.db;
  const html = `
    <div class="col-12 col-md-4">
      <div class="cardx p-3 kpi">
        <div><div class="soft small">Sayaç Online</div><div class="v mono">${online} / ${total}</div></div>
        <div>${online===total ? "✅" : (online>0 ? "🟡" : "🔴")}</div>
      </div>
    </div>
    <div class="col-6 col-md-4">
      <div class="cardx p-3 kpi">
        <div><div class="soft small">Collector</div><div class="v">${col.online ? "ONLINE" : "OFFLINE"}</div></div>
        <div>${col.online ? "🟢" : "🔴"}</div>
      </div>
    </div>
    <div class="col-6 col-md-4">
      <div class="cardx p-3 kpi">
        <div><div class="soft small">MySQL</div><div class="v">${db ? "BAĞLI" : "KOPUK"}</div></div>
        <div>${db ? "🟢" : "🔴"}</div>
      </div>
    </div>
  `;
  document.getElementById("kpis").innerHTML = html;
}

function renderCards(items){
  const grid = document.getElementById("grid");
  grid.innerHTML = "";
  items.forEach(it=>{
    const online = Number(it.online)===1;
    const dot = online ? "background:#22c55e" : "background:#ef4444";
    const err = (it.last_error && !online) ? `<div class="small text-danger mt-2">⚠ ${esc(it.last_error)}</div>` : "";
    const card = document.createElement("div");
    card.className = "col-12 col-md-6 col-xl-4";
    card.innerHTML = `
      <div class="cardx p-3">
        <div class="d-flex align-items-start justify-content-between">
          <div>
            <div class="fw-bold">${esc(it.name||"Sayaç")}</div>
            <div class="soft small mono">${esc(it.ip)}:${esc(it.port)} • Unit: ${esc(it.unit_id ?? "-")}</div>
          </div>
          <div class="text-end">
            <div class="small"><span class="dot" style="${dot}"></span>${online?"Online":"Offline"}</div>
            <div class="soft small mono">Age: ${esc(it.age_sec ?? "-")} sn • RTT: ${esc(it.rtt_ms ?? "-")} ms</div>
          </div>
        </div>
        ${err}
        <hr class="my-3">
        <div class="row g-2 small mono">
          <div class="col-6"><div class="soft">Frekans</div><div class="fw-semibold">${fmt(it.freq_hz,3)} Hz</div></div>
          <div class="col-6"><div class="soft">P Toplam</div><div class="fw-semibold">${fmt(it.p_total_kw,3)} kW</div></div>

          <div class="col-4"><div class="soft">VLN1</div><div class="fw-semibold">${fmt(it.vln1_v,2)} V</div></div>
          <div class="col-4"><div class="soft">VLN2</div><div class="fw-semibold">${fmt(it.vln2_v,2)} V</div></div>
          <div class="col-4"><div class="soft">VLN3</div><div class="fw-semibold">${fmt(it.vln3_v,2)} V</div></div>

          <div class="col-4"><div class="soft">IL1</div><div class="fw-semibold">${fmt(it.il1_a,2)} A</div></div>
          <div class="col-4"><div class="soft">IL2</div><div class="fw-semibold">${fmt(it.il2_a,2)} A</div></div>
          <div class="col-4"><div class="soft">IL3</div><div class="fw-semibold">${fmt(it.il3_a,2)} A</div></div>

          <div class="col-6"><div class="soft">PF</div><div class="fw-semibold">${fmt(it.pf,3)}</div></div>
          <div class="col-6"><div class="soft">kWh (Import)</div><div class="fw-semibold">${fmt(it.kwh_import_total,3)} kWh</div></div>
        </div>
        <div class="mt-3 soft small">TS: <span class="mono">${esc(it.ts || "-")}</span></div>
      </div>
    `;
    grid.appendChild(card);
  });
}

async function refreshStatus(){
  try{
    const r = await fetch(STATUS_URL,{cache:"no-store"});
    const j = await r.json();
    if (j && j.ok) renderKpis(j);
  }catch(e){}
}

function setLastTS(){
  document.getElementById("lastTS").textContent = new Date().toLocaleString();
}

function startSSE(){
  if (!('EventSource' in window)) return false;
  try{
    const es = new EventSource(STREAM_URL);
    es.addEventListener('live', (ev)=>{
      try{
        const j = JSON.parse(ev.data);
        if (j && j.ok) renderCards(j.items||[]);
        setLastTS();
      }catch(e){}
    });
    es.addEventListener('error', ()=>{
      // fallback will handle
    });
    window.__es = es;
    return true;
  }catch(e){
    return false;
  }
}

async function fallbackPoll(){
  try{
    const r = await fetch(LIVE_URL,{cache:"no-store"});
    const j = await r.json();
    if (j && j.ok) renderCards(j.items||[]);
    setLastTS();
  }catch(e){}
}

refreshStatus();
setInterval(refreshStatus, 2000);

const ok = startSSE();
if (!ok){
  fallbackPoll();
  setInterval(fallbackPoll, 1000);
}
</script>
<?php require_once __DIR__ . '/_bottom.php'; ?>
