<?php
require_once __DIR__ . '/_auth.php';
require_login();
require_once __DIR__ . '/_db.php';
require_once __DIR__ . '/lib/simple_pdf.php';

$type = trim((string)($_GET['type'] ?? 'energy'));
$meter_id = isset($_GET['meter_id']) ? (int)$_GET['meter_id'] : 0;
$start = trim((string)($_GET['start'] ?? ''));
$end   = trim((string)($_GET['end'] ?? ''));

if ($start === '') $start = date('Y-m-d 00:00:00');
if ($end === '')   $end   = date('Y-m-d 23:59:59');
if (preg_match('/^\d{4}-\d{2}-\d{2}$/',$start)) $start .= ' 00:00:00';
if (preg_match('/^\d{4}-\d{2}-\d{2}$/',$end))   $end   .= ' 23:59:59';

$fn = "es3_{$type}_".date('Ymd_His').".pdf";
header('Content-Type: application/pdf');
header('Content-Disposition: attachment; filename="'.$fn.'"');

try {
  if ($type === 'compare') {
    $params = [$start,$end,$start,$end];
    $where = "WHERE m.is_active=1";
    if ($meter_id>0){ $where .= " AND m.id=?"; $params[]=$meter_id; }
    $sql = "
      SELECT
        m.id AS meter_id,
        m.name,
        m.ip,
        m.port,
        e.kwh_total,
        h.kw_peak,
        h.pf_avg,
        h.online_pct
      FROM meters m
      LEFT JOIN (
        SELECT meter_id, (MAX(kwh_import_total)-MIN(kwh_import_total)) AS kwh_total
        FROM meter_energy
        WHERE ts BETWEEN ? AND ?
        GROUP BY meter_id
      ) e ON e.meter_id = m.id
      LEFT JOIN (
        SELECT meter_id,
               MAX(p_total_kw) AS kw_peak,
               AVG(pf) AS pf_avg,
               AVG(CASE WHEN online=1 THEN 1 ELSE 0 END) * 100 AS online_pct
        FROM meter_history
        WHERE ts BETWEEN ? AND ?
        GROUP BY meter_id
      ) h ON h.meter_id = m.id
      $where
      ORDER BY COALESCE(e.kwh_total,0) DESC, COALESCE(h.kw_peak,0) DESC
    ";
    $st=$pdo->prepare($sql);
    $st->execute($params);
    $rows=[];
    while($r=$st->fetch(PDO::FETCH_ASSOC)){
      $rows[] = [
        '#'.$r['meter_id'].' '.$r['name'],
        $r['ip'].':'.$r['port'],
        $r['kwh_total'],
        $r['kw_peak'],
        $r['pf_avg'],
        $r['online_pct']
      ];
    }
    $pdf = spdf_output_table("ES3 Sayaç Karşılaştırma ".$start." - ".$end,
      ['Sayaç','IP','kWh','kW Peak','PF Ort.','Online %'],
      $rows
    );
    echo $pdf; exit;
  }

  if ($type === 'monthly') {
    $sql = "
      SELECT meter_id, DATE_FORMAT(ts, '%Y-%m') ym,
             MIN(kwh_import_total) kwh_start,
             MAX(kwh_import_total) kwh_end
      FROM meter_energy
      WHERE ts BETWEEN ? AND ?
      ".($meter_id>0?" AND meter_id=? ":"")."
      GROUP BY meter_id, DATE_FORMAT(ts, '%Y-%m')
      ORDER BY ym ASC
      LIMIT 2000
    ";
    $params=[$start,$end];
    if ($meter_id>0) $params[]=$meter_id;
    $st=$pdo->prepare($sql);
    $st->execute($params);
    $rows=[];
    while($r=$st->fetch(PDO::FETCH_ASSOC)){
      $cons = (is_null($r['kwh_start'])||is_null($r['kwh_end'])) ? '' : ((float)$r['kwh_end']-(float)$r['kwh_start']);
      $rows[] = [$r['ym'], $r['meter_id'], $r['kwh_start'], $r['kwh_end'], $cons];
    }
    $pdf = spdf_output_table("ES3 Aylık Enerji (kWh) ".$start." - ".$end,
      ['Ay','Sayaç','kWh Baş.','kWh Bit.','Tüketim'],
      $rows
    );
    echo $pdf; exit;
  }

  if ($type === 'power') {
    $sql = "SELECT ts, online, p_total_kw, pf, vln1_v, vln2_v, vln3_v
            FROM meter_history
            WHERE ts BETWEEN ? AND ? ".($meter_id>0?" AND meter_id=? ":"")."
            ORDER BY ts ASC
            LIMIT 2000";
    $params = [$start,$end];
    if ($meter_id>0) $params[]=$meter_id;
    $st=$pdo->prepare($sql);
    $st->execute($params);
    $rows=[];
    while($r=$st->fetch(PDO::FETCH_ASSOC)){
      $rows[] = [$r['ts'], $r['online'], $r['p_total_kw'], $r['pf'], $r['vln1_v'], $r['vln2_v'], $r['vln3_v']];
    }
    $pdf = spdf_output_table("ES3 Güç Raporu (kW) ".$start." - ".$end,
      ['TS','ON','kW','PF','V1','V2','V3'],
      $rows
    );
    echo $pdf; exit;
  }

  $sql = "
    SELECT meter_id, DATE(ts) d,
           MIN(kwh_import_total) kwh_start,
           MAX(kwh_import_total) kwh_end
    FROM meter_energy
    WHERE ts BETWEEN ? AND ?
    ".($meter_id>0?" AND meter_id=? ":"")."
    GROUP BY meter_id, DATE(ts)
    ORDER BY d ASC
    LIMIT 2000
  ";
  $params=[$start,$end];
  if ($meter_id>0) $params[]=$meter_id;
  $st=$pdo->prepare($sql);
  $st->execute($params);
  $rows=[];
  while($r=$st->fetch(PDO::FETCH_ASSOC)){
    $cons = (is_null($r['kwh_start'])||is_null($r['kwh_end'])) ? '' : ((float)$r['kwh_end']-(float)$r['kwh_start']);
    $rows[] = [$r['d'], $r['meter_id'], $r['kwh_start'], $r['kwh_end'], $cons];
  }
  $pdf = spdf_output_table("ES3 Enerji (kWh) Günlük Özet ".$start." - ".$end,
    ['Gün','Sayaç','kWh Baş.','kWh Bit.','Tüketim'],
    $rows
  );
  echo $pdf;
} catch (Throwable $e){
  $pdf = spdf_output_table("ES3 PDF Hata", ['Mesaj'], [[ $e->getMessage() ]]);
  echo $pdf;
}
