<?php
require_once __DIR__ . '/_auth.php';
require_login();
require_once __DIR__ . '/_db.php';

$type = trim((string)($_GET['type'] ?? 'energy'));
$meter_id = isset($_GET['meter_id']) ? (int)$_GET['meter_id'] : 0;
$start = trim((string)($_GET['start'] ?? ''));
$end   = trim((string)($_GET['end'] ?? ''));

if ($start === '') $start = date('Y-m-d 00:00:00');
if ($end === '')   $end   = date('Y-m-d 23:59:59');
if (preg_match('/^\d{4}-\d{2}-\d{2}$/',$start)) $start .= ' 00:00:00';
if (preg_match('/^\d{4}-\d{2}-\d{2}$/',$end))   $end   .= ' 23:59:59';

$fn = "es3_{$type}_".date('Ymd_His').".xls";
header('Content-Type: application/vnd.ms-excel; charset=UTF-8');
header('Content-Disposition: attachment; filename="'.$fn.'"');
echo "\xEF\xBB\xBF"; // UTF-8 BOM

function h($s){ return htmlspecialchars((string)$s, ENT_QUOTES, 'UTF-8'); }

try {
  if ($type === 'compare') {
    $params = [$start,$end,$start,$end];
    $where = "WHERE m.is_active=1";
    if ($meter_id>0){ $where .= " AND m.id=?"; $params[]=$meter_id; }
    $sql = "
      SELECT
        m.id AS meter_id,
        m.name,
        m.ip,
        m.port,
        e.kwh_total,
        h.kw_peak,
        h.pf_avg,
        h.online_pct
      FROM meters m
      LEFT JOIN (
        SELECT meter_id, (MAX(kwh_import_total)-MIN(kwh_import_total)) AS kwh_total
        FROM meter_energy
        WHERE ts BETWEEN ? AND ?
        GROUP BY meter_id
      ) e ON e.meter_id = m.id
      LEFT JOIN (
        SELECT meter_id,
               MAX(p_total_kw) AS kw_peak,
               AVG(pf) AS pf_avg,
               AVG(CASE WHEN online=1 THEN 1 ELSE 0 END) * 100 AS online_pct
        FROM meter_history
        WHERE ts BETWEEN ? AND ?
        GROUP BY meter_id
      ) h ON h.meter_id = m.id
      $where
      ORDER BY COALESCE(e.kwh_total,0) DESC, COALESCE(h.kw_peak,0) DESC
    ";
    $st=$pdo->prepare($sql);
    $st->execute($params);
    $rows=$st->fetchAll(PDO::FETCH_ASSOC);

    echo "<table border='1'><tr>".
      "<th>Sayaç</th><th>Ad</th><th>IP</th><th>Port</th><th>kWh</th><th>kW Peak</th><th>PF Ort.</th><th>Online %</th>".
      "</tr>";
    foreach($rows as $r){
      echo "<tr>";
      echo "<td>".h($r['meter_id'])."</td>";
      echo "<td>".h($r['name'])."</td>";
      echo "<td>".h($r['ip'])."</td>";
      echo "<td>".h($r['port'])."</td>";
      echo "<td>".h($r['kwh_total'])."</td>";
      echo "<td>".h($r['kw_peak'])."</td>";
      echo "<td>".h($r['pf_avg'])."</td>";
      echo "<td>".h($r['online_pct'])."</td>";
      echo "</tr>";
    }
    echo "</table>";
    exit;
  }

  if ($type === 'monthly') {
    $sql = "
      SELECT meter_id, DATE_FORMAT(ts, '%Y-%m') ym,
             MIN(kwh_import_total) kwh_start,
             MAX(kwh_import_total) kwh_end
      FROM meter_energy
      WHERE ts BETWEEN ? AND ?
      ".($meter_id>0?" AND meter_id=? ":"")."
      GROUP BY meter_id, DATE_FORMAT(ts, '%Y-%m')
      ORDER BY ym ASC
    ";
    $params = [$start,$end];
    if ($meter_id>0) $params[]=$meter_id;
    $st=$pdo->prepare($sql);
    $st->execute($params);
    $rows=$st->fetchAll(PDO::FETCH_ASSOC);

    echo "<table border='1'><tr><th>Ay</th><th>Sayaç</th><th>kWh Başlangıç</th><th>kWh Bitiş</th><th>Tüketim (kWh)</th></tr>";
    foreach($rows as $r){
      $cons = (is_null($r['kwh_start'])||is_null($r['kwh_end'])) ? '' : ((float)$r['kwh_end']-(float)$r['kwh_start']);
      echo "<tr>";
      echo "<td>".h($r['ym'])."</td>";
      echo "<td>".h($r['meter_id'])."</td>";
      echo "<td>".h($r['kwh_start'])."</td>";
      echo "<td>".h($r['kwh_end'])."</td>";
      echo "<td>".h($cons)."</td>";
      echo "</tr>";
    }
    echo "</table>";
    exit;
  }

  if ($type === 'power') {
    $sql = "SELECT ts, online, p_total_kw, pf, vln1_v, vln2_v, vln3_v, il1_a, il2_a, il3_a
            FROM meter_history
            WHERE ts BETWEEN ? AND ? ".($meter_id>0?" AND meter_id=? ":"")."
            ORDER BY ts ASC";
    $params = [$start,$end];
    if ($meter_id>0) $params[]=$meter_id;
    $st=$pdo->prepare($sql);
    $st->execute($params);
    $rows=$st->fetchAll(PDO::FETCH_ASSOC);

    echo "<table border='1'><tr>
      <th>Tarih</th><th>Online</th><th>kW</th><th>PF</th>
      <th>V1</th><th>V2</th><th>V3</th>
      <th>I1</th><th>I2</th><th>I3</th>
    </tr>";
    foreach($rows as $r){
      echo "<tr>";
      echo "<td>".h($r['ts'])."</td>";
      echo "<td>".h($r['online'])."</td>";
      echo "<td>".h($r['p_total_kw'])."</td>";
      echo "<td>".h($r['pf'])."</td>";
      echo "<td>".h($r['vln1_v'])."</td>";
      echo "<td>".h($r['vln2_v'])."</td>";
      echo "<td>".h($r['vln3_v'])."</td>";
      echo "<td>".h($r['il1_a'])."</td>";
      echo "<td>".h($r['il2_a'])."</td>";
      echo "<td>".h($r['il3_a'])."</td>";
      echo "</tr>";
    }
    echo "</table>";
    exit;
  }

  // energy summary daily
  $sql = "
    SELECT meter_id, DATE(ts) d,
           MIN(kwh_import_total) kwh_start,
           MAX(kwh_import_total) kwh_end
    FROM meter_energy
    WHERE ts BETWEEN ? AND ?
    ".($meter_id>0?" AND meter_id=? ":"")."
    GROUP BY meter_id, DATE(ts)
    ORDER BY d ASC
  ";
  $params=[$start,$end];
  if ($meter_id>0) $params[]=$meter_id;
  $st=$pdo->prepare($sql);
  $st->execute($params);
  $rows=$st->fetchAll(PDO::FETCH_ASSOC);

  echo "<table border='1'><tr><th>Gün</th><th>Sayaç</th><th>kWh Başlangıç</th><th>kWh Bitiş</th><th>Tüketim (kWh)</th></tr>";
  foreach($rows as $r){
    $cons = (is_null($r['kwh_start'])||is_null($r['kwh_end'])) ? '' : ((float)$r['kwh_end']-(float)$r['kwh_start']);
    echo "<tr>";
    echo "<td>".h($r['d'])."</td>";
    echo "<td>".h($r['meter_id'])."</td>";
    echo "<td>".h($r['kwh_start'])."</td>";
    echo "<td>".h($r['kwh_end'])."</td>";
    echo "<td>".h($cons)."</td>";
    echo "</tr>";
  }
  echo "</table>";
} catch (Throwable $e){
  echo "Hata: ".h($e->getMessage());
}
