<?php
$title = "API Ayarları";
$nav = "api";
require_once __DIR__ . "/_top.php";

// Mevcut API_KEY'i (maskeli) göstermek için config'i okuyalım.
$CURRENT_API_KEY = null;
try{
  $cfgPath = __DIR__ . "/../api/_config.php";
  if (is_file($cfgPath)) {
    require $cfgPath; // $API_KEY
    if (isset($API_KEY) && is_string($API_KEY) && $API_KEY !== "") $CURRENT_API_KEY = $API_KEY;
  }
}catch(Throwable $e){
  $CURRENT_API_KEY = null;
}

function mask_key($k){
  $k = (string)$k;
  $len = strlen($k);
  if ($len <= 8) return str_repeat("*", max(0,$len-2)) . substr($k, -2);
  return str_repeat("*", $len-6) . substr($k, -6);
}

$baseUrl = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' ? 'https' : 'http') . '://' . ($_SERVER['HTTP_HOST'] ?? '') . rtrim(dirname(dirname($_SERVER['REQUEST_URI'] ?? '')),'/') . '/api';
?>
<div class="d-flex align-items-center justify-content-between mb-3">
  <div>
    <div class="h5 fw-bold mb-0">⚙️ API Ayarları</div>
    <div class="soft small">Collector ↔ Hosting API bağlantısı, anahtar üretimi ve hızlı kontroller</div>
  </div>
</div>

<div class="row g-3">
  <div class="col-12 col-lg-6">
    <div class="cardx p-3">
      <div class="fw-semibold mb-2">1) API Base URL</div>
      <div class="input-group">
        <input id="baseUrl" class="form-control mono" value="<?php echo htmlspecialchars($baseUrl, ENT_QUOTES, 'UTF-8'); ?>" readonly>
        <button class="btn btn-outline-secondary" type="button" onclick="copyText('baseUrl')">Kopyala</button>
      </div>
      <div class="soft small mt-2">Bu URL, <span class="mono">collector/config.json</span> içindeki <span class="mono">api.base_url</span> alanına yazılır.</div>
    </div>
  </div>

  <div class="col-12 col-lg-6">
    <div class="cardx p-3">
      <div class="fw-semibold mb-2">2) Mevcut API Key (Hosting)</div>
      <div class="d-flex gap-2 align-items-center">
        <input id="currentKey" class="form-control mono" value="<?php echo $CURRENT_API_KEY ? htmlspecialchars(mask_key($CURRENT_API_KEY), ENT_QUOTES, 'UTF-8') : 'Bulunamadı'; ?>" readonly>
        <?php if ($CURRENT_API_KEY): ?>
          <button class="btn btn-outline-secondary" type="button" onclick="toggleReveal()">Göster</button>
        <?php endif; ?>
      </div>
      <div class="soft small mt-2">Anahtar <span class="mono">public_html/api/_config.php</span> dosyasında durur. Güvenlik için burada maskeli gösterilir.</div>
    </div>
  </div>

  <div class="col-12">
    <div class="cardx p-3">
      <div class="fw-semibold mb-2">3) Yeni API Key Üret</div>
      <div class="row g-2">
        <div class="col-12 col-lg-6">
          <div class="input-group">
            <input id="newKey" class="form-control mono" placeholder="Yeni anahtar üret..." value="">
            <button class="btn btn-dark" type="button" onclick="genKey()">Üret</button>
            <button class="btn btn-outline-secondary" type="button" onclick="copyText('newKey')">Kopyala</button>
          </div>
          <div class="soft small mt-2">Üretilen anahtarı hem <span class="mono">api/_config.php</span> içine hem de <span class="mono">collector/config.json</span> içine aynı şekilde yaz.</div>
        </div>
        <div class="col-12 col-lg-6">
          <div class="d-grid d-lg-flex gap-2">
            <button class="btn btn-primary" type="button" onclick="buildCollectorConfig()">Collector config.json Üret</button>
            <button class="btn btn-success" type="button" onclick="buildApiConfigSnippet()">api/_config.php Snippet Üret</button>
          </div>
          <div class="soft small mt-2">Butonlar aşağıya kopyalanabilir hazır içerik üretir.</div>
        </div>
      </div>

      <div class="mt-3">
        <label class="form-label soft small mb-1">Collector config.json (kopyala-yapıştır)</label>
        <textarea id="collectorSnippet" class="form-control mono" rows="7" placeholder="Butona basınca burada oluşur..." readonly></textarea>
        <div class="d-flex justify-content-end mt-2">
          <button class="btn btn-outline-secondary btn-sm" type="button" onclick="copyText('collectorSnippet')">Kopyala</button>
        </div>
      </div>

      <div class="mt-3">
        <label class="form-label soft small mb-1">api/_config.php snippet (kopyala-yapıştır)</label>
        <textarea id="apiSnippet" class="form-control mono" rows="7" placeholder="Butona basınca burada oluşur..." readonly></textarea>
        <div class="d-flex justify-content-end mt-2">
          <button class="btn btn-outline-secondary btn-sm" type="button" onclick="copyText('apiSnippet')">Kopyala</button>
        </div>
      </div>
    </div>
  </div>

  <div class="col-12">
    <div class="cardx p-3">
      <div class="fw-semibold mb-2">4) Hızlı Sağlık Testi</div>
      <div class="row g-2">
        <div class="col-12 col-lg-4">
          <button class="btn btn-outline-dark w-100" type="button" onclick="checkHealth()">API/DB Durumu (health.php)</button>
        </div>
        <div class="col-12 col-lg-4">
          <button class="btn btn-outline-dark w-100" type="button" onclick="checkStatus()">Collector/Sayaç Durumu (status.php)</button>
        </div>
        <div class="col-12 col-lg-4">
          <button class="btn btn-outline-dark w-100" type="button" onclick="openApi()">API Klasörü Aç</button>
        </div>
      </div>
      <pre id="healthOut" class="mt-3 mono small p-3 bg-light rounded-3" style="white-space:pre-wrap; min-height: 84px;">Çıktı burada görünecek...</pre>
      <div class="soft small">Not: <span class="mono">health.php</span> anahtar istemez. <span class="mono">meter_push.php</span> ise JSON içinde <span class="mono">api_key</span> ister.</div>
    </div>
  </div>
</div>

<script>
const CURRENT_REAL_KEY = <?php echo $CURRENT_API_KEY ? json_encode($CURRENT_API_KEY) : "null"; ?>;
let revealed = false;

function toggleReveal(){
  if(!CURRENT_REAL_KEY) return;
  const el = document.getElementById('currentKey');
  revealed = !revealed;
  el.value = revealed ? CURRENT_REAL_KEY : "<?php echo $CURRENT_API_KEY ? htmlspecialchars(mask_key($CURRENT_API_KEY), ENT_QUOTES, 'UTF-8') : 'Bulunamadı'; ?>";
}

function randKey(len=48){
  const chars = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";
  let out = "";
  const a = new Uint32Array(len);
  if (window.crypto && window.crypto.getRandomValues){
    window.crypto.getRandomValues(a);
    for (let i=0;i<len;i++) out += chars[a[i] % chars.length];
  } else {
    for (let i=0;i<len;i++) out += chars[Math.floor(Math.random()*chars.length)];
  }
  return out;
}

function genKey(){
  document.getElementById('newKey').value = randKey(48);
  buildCollectorConfig();
  buildApiConfigSnippet();
}

function copyText(id){
  const el = document.getElementById(id);
  el.select();
  el.setSelectionRange(0, 999999);
  document.execCommand('copy');
}

function getKey(){
  const k = document.getElementById('newKey').value.trim();
  if(!k) return null;
  return k;
}

function buildCollectorConfig(){
  const k = getKey();
  const baseUrl = document.getElementById('baseUrl').value.trim();
  if(!k){ alert("Önce yeni API key üret veya yaz."); return; }
  const obj = {
    "api": {
      "base_url": baseUrl,
      "api_key": k,
      "timeout_sec": 15
    },
    "read": {
      "interval_sec": 1
    },
    "modbus": {
      "timeout_sec": 3,
      "blocks": {
        "measurements": {"start": 0, "count": 160},
        "energy": {"start": 1024, "count": 100}
      },
      "points": {
        "freq_hz": {"addr": 20, "type": "f32", "scale": 1.0},
        "vln1_v": {"addr": 2, "type": "f32", "scale": 1.0},
        "vln2_v": {"addr": 4, "type": "f32", "scale": 1.0},
        "vln3_v": {"addr": 6, "type": "f32", "scale": 1.0},
        "il1_a": {"addr": 34, "type": "f32", "scale": 1.0},
        "il2_a": {"addr": 36, "type": "f32", "scale": 1.0},
        "il3_a": {"addr": 38, "type": "f32", "scale": 1.0},
        "p_total_kw": {"addr": 96, "type": "f32", "scale": 0.001},
        "pf": {"addr": 118, "type": "f32", "scale": 1.0}
      },
      "energy_points": {
        "kwh_import_total": {"addr": 1044, "type": "u64", "scale": 0.001},
        "kwh_export_total": {"addr": 1068, "type": "u64", "scale": 0.001}
      }
    },
    "meters": []
  };

  document.getElementById('collectorConfigText').value = JSON.stringify(obj, null, 2);
}

function buildApiConfigSnippet(){
  const k = getKey();
  if(!k){ alert("Önce yeni API key üret veya yaz."); return; }
  const snippet =
`<?php
// api/_config.php
$API_KEY = "` + k + `";
$OFFLINE_AFTER_SEC = 15;            // sayaç offline sayılma eşiği (sn)
$COLLECTOR_FRESHNESS_SEC = 10;      // collector heartbeat tazelik eşiği (sn)

$MAIL_ENABLED = false;
$MAIL_FROM = "noreply@domain.com";
$MAIL_TO_DEFAULT = "";
?>`;
  document.getElementById('apiSnippet').value = snippet;
}

async function checkHealth(){
  const out = document.getElementById('healthOut');
  out.textContent = "Kontrol ediliyor...";
  try{
    const r = await fetch("../api/health.php?ts="+Date.now(), {cache:"no-store"});
    const j = await r.json();
    out.textContent = JSON.stringify(j, null, 2);
  }catch(e){
    out.textContent = "Hata: " + (e && e.message ? e.message : e);
  }
}

async function checkStatus(){
  const out = document.getElementById('healthOut');
  out.textContent = "Kontrol ediliyor...";
  try{
    const r = await fetch("../api/status.php?ts="+Date.now(), {cache:"no-store"});
    const j = await r.json();
    out.textContent = JSON.stringify(j, null, 2);
  }catch(e){
    out.textContent = "Hata: " + (e && e.message ? e.message : e);
  }
}

function openApi(){
  window.open("../api/health.php", "_blank");
}
</script>
<?php require_once __DIR__ . "/_bottom.php"; ?>
