<?php
require_once __DIR__ . '/_auth.php';
require_login();
require_once __DIR__ . '/_db.php';

if ($_SERVER['REQUEST_METHOD'] !== 'POST') { header('Location: reports.php'); exit; }

function fnum($k){
  if (!isset($_POST[$k]) || $_POST[$k]==='') return null;
  $v = str_replace([' ','.',','], ['','','.'], (string)$_POST[$k]);
  return is_numeric($v) ? (float)$v : null;
}
function fint($k,$def=null){
  if (!isset($_POST[$k]) || $_POST[$k]==='') return $def;
  return (int)$_POST[$k];
}

$meter_id = (int)($_POST['meter_id'] ?? 0);
if ($meter_id <= 0){ header('Location: reports.php?tab=settings&err=1'); exit; }

$offline_after_sec = max(1, (int)($_POST['offline_after_sec'] ?? 5));
$kw_peak_limit = fnum('kw_peak_limit');
$pf_min = fnum('pf_min');
$v_min = fnum('v_min');
$v_max = fnum('v_max');
$email_to = trim((string)($_POST['email_to'] ?? ''));
$email_enabled = isset($_POST['email_enabled']) ? 1 : 0;

$st = $pdo->prepare("
  INSERT INTO meter_thresholds (meter_id, offline_after_sec, kw_peak_limit, pf_min, v_min, v_max, email_to, email_enabled)
  VALUES (?,?,?,?,?,?,?,?)
  ON DUPLICATE KEY UPDATE
    offline_after_sec=VALUES(offline_after_sec),
    kw_peak_limit=VALUES(kw_peak_limit),
    pf_min=VALUES(pf_min),
    v_min=VALUES(v_min),
    v_max=VALUES(v_max),
    email_to=VALUES(email_to),
    email_enabled=VALUES(email_enabled)
");
$st->execute([$meter_id, $offline_after_sec, $kw_peak_limit, $pf_min, $v_min, $v_max, ($email_to!==''?$email_to:null), $email_enabled]);

header('Location: reports.php?tab=settings&ok=1');
exit;
