<?php
// panel/_auth.php — DB kullanıcı girişli
session_start();
require_once __DIR__ . '/_db.php';

function is_logged_in(): bool {
  return (bool)($_SESSION['panel_user_id'] ?? false);
}

function require_login(){
  if (!is_logged_in()){
    header("Location: login.php");
    exit;
  }
}

function do_login(string $username, string $password): bool {
  global $pdo;

  $st = $pdo->prepare("SELECT id, username, pass_hash, is_active FROM panel_users WHERE username=? LIMIT 1");
  $st->execute([$username]);
  $u = $st->fetch();
  if(!$u) return false;
  if((int)$u['is_active'] !== 1) return false;

  $hash = (string)$u['pass_hash'];
  if (!password_verify($password, $hash)) return false;

  $_SESSION['panel_user_id'] = (int)$u['id'];
  $_SESSION['panel_username'] = (string)$u['username'];

  $pdo->prepare("UPDATE panel_users SET last_login=? WHERE id=?")->execute([date('Y-m-d H:i:s'), (int)$u['id']]);
  return true;
}

function do_logout(){
  $_SESSION = [];
  if (ini_get("session.use_cookies")) {
    $params = session_get_cookie_params();
    setcookie(session_name(), '', time() - 42000,
      $params["path"], $params["domain"],
      $params["secure"], $params["httponly"]
    );
  }
  session_destroy();
}
