<?php
// api/stream.php — Server-Sent Events (SSE)
// Shared hosting için: kısa ömürlü stream (25 sn), client otomatik reconnect eder.
require_once __DIR__ . '/_db.php';
require_once __DIR__ . '/_config.php';

@ini_set('output_buffering', 'off');
@ini_set('zlib.output_compression', 0);

header('Content-Type: text/event-stream; charset=UTF-8');
header('Cache-Control: no-cache, no-transform');
header('Connection: keep-alive');

$start = time();
$maxSec = 25;

function emit($event, $data){
  echo "event: {$event}\n";
  echo "data: " . json_encode($data, JSON_UNESCAPED_UNICODE) . "\n\n";
  @ob_flush();
  @flush();
}

if(!$pdo){
  emit('error', ['ok'=>false,'error'=>'db_down','time'=>date('Y-m-d H:i:s')]);
  exit;
}

while(true){
  $rows = $pdo->query("
    SELECT
      m.id, m.name, m.ip, m.port, m.unit_id,
      l.ts, l.online, l.rtt_ms, l.last_error,
      l.freq_hz, l.vln1_v, l.vln2_v, l.vln3_v,
      l.vll1_v, l.vll2_v, l.vll3_v,
      l.il1_a, l.il2_a, l.il3_a, l.iln_a,
      l.p_total_kw, l.q_total_kvar, l.s_total_kva, l.pf,
      l.kwh_import_total, l.kwh_export_total, l.kwh_t1, l.kwh_t2, l.kwh_t3, l.kwh_t4
    FROM meters m
    LEFT JOIN meter_last l ON l.meter_id = m.id
    WHERE m.is_active = 1
    ORDER BY m.id ASC
  ")->fetchAll();

  $items = [];
  foreach($rows as $r){
    $ts = $r['ts'];
    $age = ($ts ? max(0, time() - strtotime($ts)) : null);
    $fresh = ($age !== null && $age <= $METER_FRESHNESS_SEC);
    $items[] = [
      'id'=>(int)$r['id'],
      'name'=>$r['name'],
      'ip'=>$r['ip'],
      'port'=>(int)$r['port'],
      'unit_id'=>$r['unit_id'] !== null ? (int)$r['unit_id'] : null,
      'ts'=>$ts,
      'age_sec'=>$age,
      'online'=>(((int)($r['online'] ?? 0)===1) && $fresh) ? 1 : 0,
      'rtt_ms'=>$r['rtt_ms'] !== null ? (int)$r['rtt_ms'] : null,
      'last_error'=>$r['last_error'],
      'freq_hz'=>$r['freq_hz'],
      'vln1_v'=>$r['vln1_v'],
      'vln2_v'=>$r['vln2_v'],
      'vln3_v'=>$r['vln3_v'],
      'vll1_v'=>$r['vll1_v'],
      'vll2_v'=>$r['vll2_v'],
      'vll3_v'=>$r['vll3_v'],
      'il1_a'=>$r['il1_a'],
      'il2_a'=>$r['il2_a'],
      'il3_a'=>$r['il3_a'],
      'iln_a'=>$r['iln_a'],
      'p_total_kw'=>$r['p_total_kw'],
      'q_total_kvar'=>$r['q_total_kvar'],
      's_total_kva'=>$r['s_total_kva'],
      'pf'=>$r['pf'],
      'kwh_import_total'=>$r['kwh_import_total'],
      'kwh_export_total'=>$r['kwh_export_total'],
      'kwh_t1'=>$r['kwh_t1'],
      'kwh_t2'=>$r['kwh_t2'],
      'kwh_t3'=>$r['kwh_t3'],
      'kwh_t4'=>$r['kwh_t4'],
    ];
  }

  emit('live', ['ok'=>true,'items'=>$items,'time'=>date('Y-m-d H:i:s')]);

  if (connection_aborted()) break;
  if ((time() - $start) >= $maxSec) break;

  usleep(1000*1000); // 1 sn
}
