<?php
require_once __DIR__ . '/_db.php';
require_once __DIR__ . '/_config.php';
require_once __DIR__ . '/_utils.php';

$out = [
  'ok' => false,
  'time' => now_str(),
  'api' => true,
  'db' => false,
  'collector' => [
    'online' => false,
    'last_seen' => null,
    'age_sec' => null,
    'collector_id' => null,
    'host_name' => null,
    'version' => null,
    'last_error' => null
  ],
  'meters' => []
];

if (!$pdo) json_out($out);

try{
  $pdo->query("SELECT 1")->fetch();
  $out['db'] = true;
}catch(Throwable $e){
  json_out($out);
}

$hb = $pdo->query("SELECT * FROM collector_heartbeat ORDER BY last_seen DESC LIMIT 1")->fetch();
if ($hb){
  $age = max(0, time() - strtotime($hb['last_seen']));
  $out['collector'] = [
    'online' => ($age <= $COLLECTOR_FRESHNESS_SEC) && ((int)$hb['last_ok'] === 1),
    'last_seen' => $hb['last_seen'],
    'age_sec' => $age,
    'collector_id' => $hb['collector_id'],
    'host_name' => $hb['host_name'],
    'version' => $hb['version'],
    'last_error' => $hb['last_error'],
  ];
}

$rows = $pdo->query("
  SELECT
    m.id, m.name, m.ip, m.port, m.unit_id,
    l.ts, l.online, l.rtt_ms, l.last_error
  FROM meters m
  LEFT JOIN meter_last l ON l.meter_id = m.id
  WHERE m.is_active = 1
  ORDER BY m.id ASC
")->fetchAll();

foreach($rows as $r){
  $ts = $r['ts'];
  $age = ($ts ? max(0, time() - strtotime($ts)) : null);
  $fresh = ($age !== null && $age <= $METER_FRESHNESS_SEC);
  $online = ((int)($r['online'] ?? 0) === 1) && $fresh;

  $out['meters'][] = [
    'id' => (int)$r['id'],
    'name' => $r['name'],
    'ip' => $r['ip'],
    'port' => (int)$r['port'],
    'unit_id' => $r['unit_id'] !== null ? (int)$r['unit_id'] : null,
    'last_ts' => $ts,
    'age_sec' => $age,
    'online' => $online,
    'rtt_ms' => $r['rtt_ms'] !== null ? (int)$r['rtt_ms'] : null,
    'last_error' => $r['last_error']
  ];
}

$out['ok'] = $out['db'];
json_out($out);
