<?php
require_once __DIR__ . '/_db.php';
require_once __DIR__ . '/_utils.php';
if(!$pdo) json_out(['ok'=>false,'error'=>'db_down']);
$limit = (int)($_GET['limit'] ?? 80);
if ($limit < 10) $limit = 10;
if ($limit > 300) $limit = 300;
$rows = $pdo->prepare("
  SELECT e.id, e.ts, e.level, e.source, e.message, e.meter_id, m.name as meter_name, m.ip
  FROM system_events e
  LEFT JOIN meters m ON m.id = e.meter_id
  ORDER BY e.ts DESC
  LIMIT ?
");
$rows->bindValue(1, $limit, PDO::PARAM_INT);
$rows->execute();
json_out(['ok'=>true,'items'=>$rows->fetchAll()]);
