<?php
// api/_utils.php
function json_out($arr, $code=200){
  http_response_code($code);
  header('Content-Type: application/json; charset=UTF-8');
  echo json_encode($arr);
  exit;
}
function now_str(){ return date('Y-m-d H:i:s'); }
function num_or_null($v){ return (is_numeric($v) ? (float)$v : null); }
function u64_or_null($v){ return (is_numeric($v) && $v >= 0 ? (string)$v : null); }

function require_api_key($API_KEY){
  $raw = file_get_contents('php://input');
  if (!$raw) json_out(['ok'=>false,'error'=>'empty_body'], 400);
  $data = json_decode($raw, true);
  if (!is_array($data)) json_out(['ok'=>false,'error'=>'bad_json'], 400);
  if (($data['api_key'] ?? '') !== $API_KEY) json_out(['ok'=>false,'error'=>'unauthorized'], 401);
  return $data;
}

function event_insert($pdo, $level, $source, $message, $meter_id=null){
  try{
    $st = $pdo->prepare("INSERT INTO system_events (ts, level, source, meter_id, message) VALUES (?,?,?,?,?)");
    $st->execute([now_str(), $level, $source, $meter_id, mb_substr((string)$message,0,255,'UTF-8')]);
  }catch(Throwable $e){}
}
